#include "DTreeViewDirectorios.h"
#include <shlobj.h>
#include "DAplicacion.h"

#pragma comment(lib, "mpr.lib")				// Libreria para redes de microsoft windows

namespace DWL {

	//
    //! Funcin para crear el TreeView.
    // HWND Crear(DWORD Estilos, HWND hWndPadre, const int cX, const int cY, const int cAncho, const int cAlto, const int cID, DWORD EstilosExtendidos = NULL);
    HWND DTreeViewDirectorios::Crear(DBaseWnd *Padre, const int cX, const int cY, const int cAncho, const int cAlto, const int cID, DWORD nEstilos, DWORD nEstilosExtendidos) {
        DTreeView::Crear(Padre, cX, cY, cAncho, cAlto, cID, nEstilos, nEstilosExtendidos);
        
        _ImageList.Crear(16, 16);
        _ImageList.AgregarIconoCSLID(CSIDL_DESKTOP);            // 0 Escritorio
        _ImageList.AgregarIconoCSLID(CSIDL_DRIVES);             // 1 Mi PC
        _ImageList.AgregarIconoCSLID(CSIDL_PERSONAL);           // 2 Mis documentos
        _ImageList.AgregarIconoCSLID(CSIDL_NETWORK);            // 3 Mis sitios de red
        _ImageList.AgregarIconoCSLID(CSIDL_DRIVES);             // 4 Recurso de red
        _ImageList.AgregarIconoCSLID(CSIDL_NETHOOD);            // 5 Directorio

        AsignarImageList(_ImageList());
        ActualizarDirectorios();
        return _hWnd;
    }

    //
    //! Funcin para asignar esta clase a un TreeView creado anteriormente en el editor de recursos.
    // void Asignar(HWND hWndPadre, const int cID);
    void DTreeViewDirectorios::Asignar(DBaseWnd *Padre, const int cID) {
        DTreeView::Asignar(Padre, cID);

        _ImageList.Crear(16, 16);
        _ImageList.AgregarIconoCSLID(CSIDL_DESKTOP);            // 0 Escritorio
        _ImageList.AgregarIconoCSLID(CSIDL_DRIVES);             // 1 Mi PC
        _ImageList.AgregarIconoCSLID(CSIDL_PERSONAL);           // 2 Mis documentos
        _ImageList.AgregarIconoCSLID(CSIDL_NETWORK);            // 3 Mis sitios de red
        _ImageList.AgregarIconoCSLID(CSIDL_DRIVES);             // 4 Recurso de red
        _ImageList.AgregarIconoCSLID(CSIDL_NETHOOD);            // 5 Directorio

        AsignarImageList(_ImageList());
        ActualizarDirectorios();
    }

    HTREEITEM DTreeViewDirectorios::AgregarNodoDirectorio(const DEnum_TreeViewDirectorios_Nodo_Tipo nTipo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe, const bool nActivado) {
        DTreeViewDirectorios_Nodo *nNodo = new DTreeViewDirectorios_Nodo(nTipo, nActivado);
        return AgregarNodo(nNodo, Parent, cTexto, cIko, InsertarDespuesDe);
    }

    // hay que encontrar la api para obtener el nombre de un directorio ej: CSIDL_DESKTOPDIRECTORY = "Escritorio"
    // creoque es SHGetFileInfo
    void DTreeViewDirectorios::ActualizarDirectorios(void) {
        BorrarTodo();

        TCHAR TmpStr[MAX_PATH + 1] = TEXT("");
        bool TieneArchivos = false;
        bool TieneDirectorios = false;

//        SHGetSpecialFolderPath(NULL, TmpStr, CSIDL_DESKTOPDIRECTORY, 0);
//        DString PathEscritorio;
//        Sistema.DirectoriosPorDefecto.Escritorio(PathEscritorio);
        DString PathEscritorioUser;
        Sistema.DirectoriosPorDefecto.Escritorio_UsuarioActual(PathEscritorioUser);

//        SHGetSpecialFolderPath(NULL, TmpStr, CSIDL_PERSONAL, 0);
//        DString PathMisDocumentos;
//        Sistema.DirectoriosPorDefecto.MisDocumentos(PathMisDocumentos);
        DString PathMisDocumentosUser;
        Sistema.DirectoriosPorDefecto.MisDocumentos_UsuarioActual(PathMisDocumentosUser);
  
        // Nodos basicos
        HTREEITEM HTI_Escritorio    = AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_Escritorio, NULL, TEXT("Escritorio"), 0);
        DTreeViewDirectorios_Nodo *TmpNodoDir = static_cast<DTreeViewDirectorios_Nodo *>(BuscarNodo(HTI_Escritorio));
//        _AgregarDirectorio(TmpNodoDir, PathEscritorio());
        _AgregarDirectorio(TmpNodoDir, PathEscritorioUser());

        HTREEITEM HTI_MiPC          = AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_MiPC, NULL, TEXT("Mi PC"), 1);
        HTREEITEM HTI_MisDocumentos = AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_MisDocumentos, NULL, TEXT("Mis Documentos"), 2);
        TmpNodoDir = static_cast<DTreeViewDirectorios_Nodo *>(BuscarNodo(HTI_MisDocumentos));
//        _AgregarDirectorio(TmpNodoDir, PathMisDocumentos());
        _AgregarDirectorio(TmpNodoDir, PathMisDocumentosUser());

        if (_MostrarRedes == true) {
            HTREEITEM HTI_MisSitiosRed  = AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_MisSitiosRed, NULL, TEXT("Mis sitios de Red"), 3);
		    AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio, HTI_MisSitiosRed, TEXT(";"), 0);
        }
    
        // Enumeracin de unidades
    	DWORD MascaraBitsUnidades = GetLogicalDrives();
        TCHAR Unidad[5] = TEXT("?:\\");
		TCHAR NombreDisco[256] = TEXT("");
		UINT  TipoUnidad = 0;
        DString TextoNodo;
		DWORD Component, Flags;
        HTREEITEM TmpNodo;
        BOOL Ret;
        TCHAR NombreSistema[128] = TEXT("");
        DEnum_TreeViewDirectorios_Nodo_Tipo nTipo;

		for (TCHAR i = 0; i < 32; i++) {
			if (MascaraBitsUnidades & (1 << i)) { // La unidad existe
			    Unidad[0] = i + TEXT('A');
			    TipoUnidad = GetDriveType(Unidad);
                switch (TipoUnidad) {
                    case DRIVE_REMOVABLE : // Disquetera
                        nTipo = DEnum_TreeViewDirectorios_Nodo_Tipo_Disquetera;
                        TextoNodo = TEXT("Disquetera ("); 
                        break;
                    case DRIVE_FIXED : // Disco duro fijo
                        nTipo = DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoDuro;
                        TextoNodo = TEXT("Disco Duro ("); 
                        break;
                    case DRIVE_REMOTE : // Disco duro de red
                        nTipo = DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoDuroRed;
                        TextoNodo = TEXT("Disco de Red ("); 
                        break;
                    case DRIVE_CDROM : // CDROM - DVDROM
                        nTipo = DEnum_TreeViewDirectorios_Nodo_Tipo_CDROM;
                        TextoNodo = TEXT("Unidad CD/DVD ("); 
                        break;
                    case DRIVE_RAMDISK : // Ram disk
                        nTipo = DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoRam;
                        TextoNodo = TEXT("Unidad RAM ("); 
                        break;
                    default :
                        nTipo = DEnum_TreeViewDirectorios_Nodo_Tipo_Desconocido;
                        TextoNodo = TEXT("Unidad desconocida ("); 
                        break;
                }
				if (Unidad[0] != TEXT('A') && Unidad[0] != TEXT('B'))	Ret = GetVolumeInformation(Unidad, NombreDisco, 256, NULL, &Component, &Flags, NombreSistema, 128);
				else													Ret = 1;
				if (Ret != 0) {
                    if (NombreDisco[0] != 0) { 
                        TextoNodo = NombreDisco; TextoNodo += TEXT(" (");
                    }
				}
                TextoNodo += static_cast<TCHAR>(i + 'A'); 
                TextoNodo += TEXT(":)");
                TieneDirectorios = _TieneDirectorios(Unidad, TieneArchivos); 
                if (TieneArchivos == true) {
                    TmpNodo = AgregarNodoDirectorio(nTipo, HTI_MiPC, TextoNodo(), 0); // ESTABLECER EL ICONO CORRECTO
                    if (TieneDirectorios == true) AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio, TmpNodo, TEXT(":"), 0);
                }
            }
        }
//		SetErrorMode(0);
    }


    void DTreeViewDirectorios::TreeView_Evento_Nodo_Expandiendo(DTreeView_Nodo *nNodo) {
        DTreeView_Nodo *nNodoHijo = nNodo->NodoHijo();
        DString TmpTxt;
        DString TmpPath;
        if (nNodoHijo != NULL) {
            nNodoHijo->ObtenerTexto(TmpTxt);
            if (TmpTxt == TEXT(":")) { // directorio normal
                _ObtenerPath(static_cast<DTreeViewDirectorios_Nodo *>(nNodo), TmpPath);
                BorrarNodo(nNodoHijo->hTreeItem());
                Sistema.Mouse.CambiarCursor(DEnum_Mouse_Cursor_Procesando);
                _AgregarDirectorio(static_cast<DTreeViewDirectorios_Nodo *>(nNodo), TmpPath());
                Sistema.Mouse.CambiarCursor();
            }
            else if (TmpTxt == TEXT(";")) { // directorio de red
                Sistema.Mouse.CambiarCursor(DEnum_Mouse_Cursor_Procesando);
				_EnumerarRed(NULL, nNodo);
                Sistema.Mouse.CambiarCursor();
//                _ObtenerPath(static_cast<DTreeViewDirectorios_Nodo *>(nNodo), TmpPath);

            }
        }
    }

    void DTreeViewDirectorios::ObtenerPathSeleccionado(DString &nPath) {
        if (Seleccion() != NULL) {
            _ObtenerPath(static_cast<DTreeViewDirectorios_Nodo *>(BuscarNodo(Seleccion())), nPath);
        }
    }

    void DTreeViewDirectorios::_ObtenerPath(DTreeViewDirectorios_Nodo *nNodo, DString &nPath) {
        DTreeViewDirectorios_Nodo *TmpNodo = nNodo;
        nPath = TEXT("");
        DString TmpPath;

        while (TmpNodo->Tipo == DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio) {
            TmpNodo->ObtenerTexto(TmpPath);
            TmpPath += TEXT("\\");
            TmpPath += nPath;
            nPath = TmpPath;
            TmpNodo = static_cast<DTreeViewDirectorios_Nodo *>(TmpNodo->NodoPadre());
        }

        switch (TmpNodo->Tipo) { 
		    case DEnum_TreeViewDirectorios_Nodo_Tipo_Escritorio : // hay que controlar si es del usuario actual o el general.......
/*                Sistema.DirectoriosPorDefecto.Escritorio(TmpPath);
                TmpPath += TEXT("\\");
                TmpPath += nPath;
                if (_ComprobarPath(nPath()) == false) {*/
                    Sistema.DirectoriosPorDefecto.Escritorio_UsuarioActual(TmpPath);
                    TmpPath += TEXT("\\");
                    TmpPath += nPath;
//                }
                nPath = TmpPath;
                break;
            case DEnum_TreeViewDirectorios_Nodo_Tipo_MisDocumentos : // hay que controlar si es del usuario actual o el general.......
/*                Sistema.DirectoriosPorDefecto.MisDocumentos(TmpPath);
                TmpPath += TEXT("\\");
                TmpPath += nPath;
                if (_ComprobarPath(nPath()) == false) {*/
                    Sistema.DirectoriosPorDefecto.MisDocumentos_UsuarioActual(TmpPath);
                    TmpPath += TEXT("\\");
                    TmpPath += nPath;
//                }
                nPath = TmpPath;
                break;
            case DEnum_TreeViewDirectorios_Nodo_Tipo_Servidor :
                TmpNodo->ObtenerTexto(TmpPath);
                TmpPath += TEXT("\\");
                TmpPath += nPath;
                nPath = TEXT("\\\\");
                nPath += TmpPath;
                break;
            case DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoDuro :
            case DEnum_TreeViewDirectorios_Nodo_Tipo_CDROM :
            case DEnum_TreeViewDirectorios_Nodo_Tipo_Disquetera :
            case DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoRam :
            case DEnum_TreeViewDirectorios_Nodo_Tipo_DiscoDuroRed :
                TmpNodo->ObtenerTexto(TmpPath);
                TmpPath = TmpPath[TmpPath.Tam() - 3];
                TmpPath += TEXT(":\\");
                TmpPath += nPath;
                nPath = TmpPath;
                break;
        }
    }

    void DTreeViewDirectorios::_EnumerarRed(LPNETRESOURCE lpnr, DTreeView_Nodo *nNodo) {
		DWORD dwResult, dwResultEnum;
		HANDLE hEnum;
		DWORD cbBuffer = 16384;     // 16K is a good size
		DWORD cEntries = -1;        // enumerate all possible entries
		LPNETRESOURCE lpnrLocal;    // pointer to enumerated structures
		DWORD i;
        HTREEITEM TmpNodo = nNodo->hTreeItem();
		size_t	Separador = 0;
		size_t	Contador;
		size_t	TamStr;
		int		IconoNodo = 0;
		DEnum_TreeViewDirectorios_Nodo_Tipo Tipo;
		DString NombreStr;

        if (lpnr == NULL) { // hay que eliminar el nodo ";"
            BorrarNodo(nNodo->Hijo());
        }

		dwResult = WNetOpenEnum(RESOURCE_GLOBALNET,	RESOURCETYPE_ANY, 0, lpnr, &hEnum);
		if (dwResult != NO_ERROR) 
            return;
		lpnrLocal = (LPNETRESOURCE) GlobalAlloc(GPTR, cbBuffer + 1);
		if (lpnrLocal == NULL) 
            return;

		do {
			if (lpnrLocal)
                ZeroMemory(lpnrLocal, cbBuffer);
			dwResultEnum = WNetEnumResource(hEnum, &cEntries, lpnrLocal, &cbBuffer);
			if (dwResultEnum == NO_ERROR) {
				for (i = 0; i < cEntries; i++) {
					TamStr = DWLStrLen(lpnrLocal[i].lpRemoteName);
					Separador = 0;
					for (Contador = TamStr; Contador > 0; Contador --) {
						if (lpnrLocal[i].lpRemoteName[Contador - 1] == TEXT('\\')) {
							Separador = Contador;
							break;
						}
					}
//					bool nActivado = false;
					switch (lpnrLocal[i].dwDisplayType) {
						case RESOURCEDISPLAYTYPE_SERVER		:
							Tipo = DEnum_TreeViewDirectorios_Nodo_Tipo_Servidor;
							IconoNodo = 4;
							break;
						case RESOURCEDISPLAYTYPE_SHARE		:
							Tipo = DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio;
							IconoNodo = 5;
//							nActivado = true;
							if (lpnrLocal[i].dwType == RESOURCETYPE_PRINT)	IconoNodo = -1;
							break;
						default								: 
							IconoNodo = 0; 
							Tipo = DEnum_TreeViewDirectorios_Nodo_Tipo_Escritorio;				
							break;
					}
					NombreStr = &lpnrLocal[i].lpRemoteName[Separador];

					if (IconoNodo > 3) {
                        TmpNodo = AgregarNodoDirectorio(Tipo, nNodo->hTreeItem(), NombreStr(), IconoNodo);
						if (IconoNodo == 5 && lpnrLocal[i].dwType == RESOURCETYPE_DISK) {
                            AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio, TmpNodo, TEXT(":"), 0);
						}
					}
					if (RESOURCEUSAGE_CONTAINER == (lpnrLocal[i].dwUsage & RESOURCEUSAGE_CONTAINER))
                        _EnumerarRed(&lpnrLocal[i], BuscarNodo(TmpNodo));

				}
			}
			else if (dwResultEnum != ERROR_NO_MORE_ITEMS) {
				break;
			}
		} while (dwResultEnum != ERROR_NO_MORE_ITEMS);

		GlobalFree((HGLOBAL) lpnrLocal);
		dwResult = WNetCloseEnum(hEnum);

        return;
    }


    const bool DTreeViewDirectorios::_ComprobarPath(const TCHAR *nPath) {
        static TCHAR Buffer[MAX_PATH];
        if (GetShortPathName(nPath, Buffer, MAX_PATH) == 0) return false;
        else                                                return true;
    }

    // Comprueba si la ruta especificada contiene algun subdirectorio
    const bool DTreeViewDirectorios::_TieneDirectorios(const TCHAR *nPath, bool &TieneArchivos) {
        TieneArchivos = false;
		WIN32_FIND_DATA		FindInfoPoint;
		HANDLE				hFind = NULL;
		DString PathBusqueda = nPath;
		if (PathBusqueda[PathBusqueda.Tam()] != '\\')	PathBusqueda += TEXT("\\*.*");
		else											PathBusqueda += TEXT("*.*");
//		SetErrorMode(SEM_FAILCRITICALERRORS);
		hFind = FindFirstFile(PathBusqueda(), &FindInfoPoint);
		if (hFind == INVALID_HANDLE_VALUE) return false;
        TieneArchivos = true;
		while (FindNextFile(hFind, &FindInfoPoint) != 0) {
			if (FindInfoPoint.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY && FindInfoPoint.cFileName[0] != TEXT('.')) {
				FindClose(hFind);
				return true;
			}
		}
		FindClose(hFind);
		return false;
    }

// Controlar si se usa misdocumentos o escriotrio y aadir el de usuario y el general
    void DTreeViewDirectorios::_AgregarDirectorio(DTreeViewDirectorios_Nodo *nNodoExpandido, const TCHAR *PathBusqueda) {
		WIN32_FIND_DATA		FindInfoPoint;
		HANDLE				hFind = NULL;
		DString             Path, PathSD, PathOrig;
        bool                TieneArchivos = false;
        HTREEITEM           nhTreeItem;
		
        PathOrig = PathBusqueda;
        if (PathOrig[PathOrig.Tam() -1] != TEXT('\\')) PathOrig += TEXT("\\");
        
        Path = PathOrig;
        Path += TEXT("*.*");

//		SetErrorMode(SEM_FAILCRITICALERRORS);
		hFind = FindFirstFile(Path(), &FindInfoPoint);
		if (hFind == INVALID_HANDLE_VALUE) {
			return;
		}

		while (FindNextFile(hFind, &FindInfoPoint) != 0) {
			if (FindInfoPoint.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY && FindInfoPoint.cFileName[0] != TEXT('.')) {
                PathSD = PathOrig;
                PathSD += FindInfoPoint.cFileName;
                PathSD += TEXT("\\");
                nhTreeItem = AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio, nNodoExpandido->hTreeItem(), FindInfoPoint.cFileName, _ImageList.AgregarIconoExplorador(PathSD()));
                if (_TieneDirectorios(PathSD(), TieneArchivos) == true) AgregarNodoDirectorio(DEnum_TreeViewDirectorios_Nodo_Tipo_Directorio, nhTreeItem, TEXT(":"), 0);
            }
        }
		FindClose(hFind);
    }


};